IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO]')) 
	BEGIN 
		RETURN;
	END
ELSE
BEGIN
	CREATE TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO](
		[CD_CTR] [int] NOT NULL,
		[CD_CTR_IT] [int] NOT NULL,
		[CD_EMP] [int] NOT NULL,
		[CD_PROD] [int] NOT NULL,
		[CD_TRIB] [int] NOT NULL,
		[VLR_PROD_UNIT] [money] NOT NULL,
		[PERC_PROD_DESC] [money] NOT NULL,
		[VLR_PROD_TOTAL] [money] NOT NULL,
		[VLR_PROD_BASE_ICMS] [money] NOT NULL,
		[VLR_PROD_ICMS] [money] NOT NULL,
		[VLR_PROD_BASE_IPI] [money] NOT NULL,
		[VLR_PROD_IPI] [money] NOT NULL,
		[PERC_PROD_IPI] [money] NOT NULL,
		[PERC_PROD_ICMS] [money] NOT NULL,
		[VLR_PROD_PMC] [money] NOT NULL,
		[VLR_PROD_BASE_ST] [money] NOT NULL,
		[VLR_PROD_ICMS_ST] [money] NOT NULL,
		[PERC_PROD_IVA_ST] [money] NOT NULL,
		[PERC_PROD_RED_BASE_ICMS] [money] NOT NULL,
		[PERC_PROD_RED_BASE_ST] [money] NOT NULL,
		[PERC_PROD_ICMS_ST] [money] NOT NULL,
		[VLR_PROD_FRETE] [money] NOT NULL,
		[QTDE_PROD] [money] NOT NULL,
		[VLR_PROD_DESC] [money] NOT NULL,
		[APRES_EMB_CP] [int] NOT NULL,
		[APRES_QT_CP] [int] NOT NULL,
		[VLR_BASE_PIS] [money] NOT NULL,
		[VLR_PIS] [money] NOT NULL,
		[PERC_ALIQ_PIS] [money] NOT NULL,
		[VLR_BASE_COFINS] [money] NOT NULL,
		[VLR_COFINS] [money] NOT NULL,
		[PERC_ALIQ_COFINS] [money] NOT NULL,
		[VLR_BASE_ICMS_RET] [money] NOT NULL,
		[VLR_ICMS_RET] [money] NOT NULL,
		[VLR_CRED_BASE_SN] [money] NOT NULL,
		[VLR_CRED_ICMS_SN] [money] NOT NULL,
		[PERC_CRED_ICMS_SIMPLES] [money] NOT NULL,
		[VLR_CRED_ICMS_SIMPLES] [money] NOT NULL,
		[VLR_OUTRAS_DESPESAS] [money] NOT NULL,
		[PERC_DESC_FINAN] [money] NOT NULL,
		[VLR_DESC_FINAN] [money] NOT NULL,
	 CONSTRAINT [PK_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] PRIMARY KEY CLUSTERED 
	(
		[CD_CTR] ASC,
		[CD_CTR_IT] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_CD_CTR]  DEFAULT ((0)) FOR [CD_CTR]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_CD_CTR_IT]  DEFAULT ((0)) FOR [CD_CTR_IT]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_CD_TRIB]  DEFAULT ((0)) FOR [CD_TRIB]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_PROD_UNIT]  DEFAULT ((0)) FOR [VLR_PROD_UNIT]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_PERC_PROD_DESC]  DEFAULT ((0)) FOR [PERC_PROD_DESC]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_PROD_TOTAL]  DEFAULT ((0)) FOR [VLR_PROD_TOTAL]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_PROD_BASE_ICMS]  DEFAULT ((0)) FOR [VLR_PROD_BASE_ICMS]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_PROD_ICMS]  DEFAULT ((0)) FOR [VLR_PROD_ICMS]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_PROD_BASE_IPI]  DEFAULT ((0)) FOR [VLR_PROD_BASE_IPI]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_PROD_IPI]  DEFAULT ((0)) FOR [VLR_PROD_IPI]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_PERC_PROD_IPI]  DEFAULT ((0)) FOR [PERC_PROD_IPI]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_PERC_PROD_ICMS]  DEFAULT ((0)) FOR [PERC_PROD_ICMS]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_PROD_PMC]  DEFAULT ((0)) FOR [VLR_PROD_PMC]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_PROD_BASE_ST]  DEFAULT ((0)) FOR [VLR_PROD_BASE_ST]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_PROD_ICMS_ST]  DEFAULT ((0)) FOR [VLR_PROD_ICMS_ST]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_PERC_IVA]  DEFAULT ((0)) FOR [PERC_PROD_IVA_ST]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_PERC_RED_BASE_ICMS]  DEFAULT ((0)) FOR [PERC_PROD_RED_BASE_ICMS]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_PERC_RED_BASE_SUBS]  DEFAULT ((0)) FOR [PERC_PROD_RED_BASE_ST]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_PERC_PROD_ICMS_ST]  DEFAULT ((0)) FOR [PERC_PROD_ICMS_ST]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_PROD_FRETE]  DEFAULT ((0)) FOR [VLR_PROD_FRETE]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_QTDE_PROD]  DEFAULT ((0)) FOR [QTDE_PROD]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_PROD_DESC]  DEFAULT ((0)) FOR [VLR_PROD_DESC]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_APRES_EMB_CP]  DEFAULT ((0)) FOR [APRES_EMB_CP]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_APRES_QT_CP]  DEFAULT ((0)) FOR [APRES_QT_CP]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_BASE_PIS]  DEFAULT ((0)) FOR [VLR_BASE_PIS]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_PIS]  DEFAULT ((0)) FOR [VLR_PIS]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_PERC_ALIQ_PIS]  DEFAULT ((0)) FOR [PERC_ALIQ_PIS]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_BASE_COFINS]  DEFAULT ((0)) FOR [VLR_BASE_COFINS]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_COFINS]  DEFAULT ((0)) FOR [VLR_COFINS]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_PERC_ALIQ_COFINS]  DEFAULT ((0)) FOR [PERC_ALIQ_COFINS]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_BASE_ICMS_RET]  DEFAULT ((0)) FOR [VLR_BASE_ICMS_RET]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_ICMS_RET]  DEFAULT ((0)) FOR [VLR_ICMS_RET]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_CRED_BASE_SN]  DEFAULT ((0)) FOR [VLR_CRED_BASE_SN]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_CRED_ICMS_SN]  DEFAULT ((0)) FOR [VLR_CRED_ICMS_SN]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_PERC_CRED_ICMS_SIMPLES]  DEFAULT ((0)) FOR [PERC_CRED_ICMS_SIMPLES]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_CRED_ICMS_SIMPLES]  DEFAULT ((0)) FOR [VLR_CRED_ICMS_SIMPLES]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] ADD  CONSTRAINT [DF_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_VLR_OUTRAS_DESPESAS]  DEFAULT ((0)) FOR [VLR_OUTRAS_DESPESAS]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_EST_NF_ENT_DANFE_PROVISORIO_ITENS] FOREIGN KEY([CD_CTR], [CD_CTR_IT])
	REFERENCES [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS] ([CD_CTR], [CD_CTR_IT])

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] CHECK CONSTRAINT [FK_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_EST_NF_ENT_DANFE_PROVISORIO_ITENS]

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
	REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])
	ON UPDATE CASCADE
	ON DELETE CASCADE

	ALTER TABLE [dbo].[EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO] CHECK CONSTRAINT [FK_EST_NF_ENT_DANFE_PROVISORIO_ITENS_VALIDACAO_IMPOSTO_EST_PROD]
END
